********************************************************************************
* frequency of pre-crisis states  
local nr_countries = sum(nr_countries )
local Model = sum(Model)

egen p_1 = mean(crisis4_12)
sum p_1 
gen p_2 =  1 - p_1

gen crisis_prob_cut = .
set more off
forvalues i = 1(1)  `nr_countries' {
		egen crisis_prob_cut`i' = cut(crisis_prob) if country_id == `i', group(100)
		replace crisis_prob_cut = crisis_prob_cut`i' if country_id == `i'
		drop crisis_prob_cut`i'
	}

forvalues j=0.90(0.05)1.00 {


** VARIABLE TO BE EVALUATED
gen EV_VAR = crisis_prob_cut
local var_name : variable label crisis_prob
gen varname = "crisis_prob"
** parameters: cons1 = mu, cons2 = 1-mu, cons3 = min(mu,1-mu), 
gen cons1 = `j'
gen cons2 = 1 - cons1 
egen cons3 = rowmin(cons1 cons2)
** period that you want to detect
gen PRECRISIS = crisis4_12

* probweighted
gen p1mu1 = p_1 * `j'
gen p2mu2 = p_2 * (1-`j')
egen wcons3 =  rowmin(p1mu1 p2mu2)

******

set more off

* generate signals based on percentile thresholds (50th to 99th percentile)
* generate counter variables for A, B, C, D fields
forvalues i=1(1)99{
gen sig`i' = .
replace sig`i' = 0 if EV_VAR < `i' & EV_VAR != . 
replace sig`i' = 1 if EV_VAR >= `i' & EV_VAR != . 
replace sig`i' = . if start_crisisf3 == 1 |start_crisisf2 == 1 | start_crisisf1 == 1 ///
					  | start_crisis == 1 | start_crisisl1 == 1 | start_crisisl2 == 1 ///
					  | start_crisisl3 == 1 | start_crisisl4 == 1 | start_crisisl5 == 1 ///
					  | start_crisisl6 == 1 | start_crisisl7 == 1 
replace sig`i' = . if bankingcrisis == 1 
gen counter_yesyes`i' = 1 if sig`i' == 1 & PRECRISIS == 1
gen counter_yesno`i' = 1 if sig`i' == 1 & PRECRISIS == 0
gen counter_noyes`i' = 1 if sig`i' == 0 & PRECRISIS == 1
gen counter_nono`i' = 1 if sig`i' == 0 & PRECRISIS == 0
}

* one percentile for all countries (means that cutoff values vary over countries while percentile remains constant)
forvalues i=1(1)99{
egen global_A`i' = total(counter_yesyes`i')
egen global_B`i' = total(counter_yesno`i')
egen global_C`i' = total(counter_noyes`i')
egen global_D`i' = total(counter_nono`i')
gen global_A_AC`i' = global_A`i' / ( global_A`i' + global_C`i' )
gen global_A_AB`i' = global_A`i' / ( global_A`i' + global_B`i' )
gen global_C_AC`i' = global_C`i' / ( global_A`i' + global_C`i' )
gen global_B_BD`i' = global_B`i' / ( global_B`i' + global_D`i' )
gen global_AC_ABCD`i' = ( global_A`i' + global_C`i' ) / ( global_A`i' + global_B`i' + global_C`i' + global_D`i' )
gen global_adj_noise_signal`i' = global_B_BD`i' / global_A_AC`i'
gen global_use`i' = cons3 - ( cons1 * global_C_AC`i' + cons2 * global_B_BD`i' )
gen weight_global_use`i' = wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' )
gen rel_weight_global_use`i' = ( wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' ) ) / wcons3
}

* identify maximum relative usefulness across percentiles
egen maxweightglobaluse = rowmax(weight_global_use*)
egen maxrelweightglobaluse = rowmax(rel_weight_global_use*)
* define the optimal thresholds and corresponding values as the ones where usefulness is at its maximum
gen optweight_thres_global = . 
gen ow_adj_noise_signal_global = .
gen optweight_perc_pred_global = . 
gen optweight_cond_prob_global = . 
gen optweight_prob_diff_global = .
gen optweight_TP = .
gen optweight_FP = .
gen optweight_TN = .
gen optweight_FN = . 
gen optweight_T1 = .
gen optweight_T2 = .
forvalues i=1(1)99{
replace optweight_thres_global = `i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace ow_adj_noise_signal_global = global_adj_noise_signal`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_perc_pred_global = global_A_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_cond_prob_global = global_A_AB`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_prob_diff_global = global_A_AB`i' - global_AC_ABCD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TP = global_A`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FP = global_B`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TN = global_D`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FN = global_C`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T1 = global_C_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T2 = global_B_BD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
}

* drop variables
forvalues i=1(1)99{
drop sig`i' counter_yesyes`i' counter_yesno`i' counter_noyes`i' counter_nono`i' ///
			global_A`i' global_B`i' global_C`i' global_D`i' global_A_AC`i'      ///
			global_A_AB`i' global_C_AC`i' global_B_BD`i' global_AC_ABCD`i'      ///
			global_adj_noise_signal`i' global_use`i' weight_global_use`i'       ///
			rel_weight_global_use`i'
			}

order varname cons1 optweight_thres_global ///
			  optweight_TP optweight_FP optweight_TN optweight_FN ///
			  optweight_T1 optweight_T2 ///
			  maxweightglobaluse maxrelweightglobaluse ///
			  ow_adj_noise_signal_global optweight_perc_pred_global ///
			  optweight_cond_prob_global optweight_prob_diff_global ///

local k = 100*`j'
gen Rel_use`k' = maxrelweightglobaluse
gen  TPR`k' = optweight_perc_pred_global
gen  FPR`k' = optweight_T2

drop PRECRISIS EV_VAR varname cons1 cons2 cons3 p1mu1 p2mu2 wcons3 optweight_thres_global ///
	 optweight_TP optweight_FP optweight_TN optweight_FN optweight_T1 optweight_T2 		  ///
	 maxweightglobaluse maxrelweightglobaluse optweight_thres_global ow_adj_noise_signal_global ///
	 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global 
	
}
drop p_1 p_2 crisis_prob_cut
